function X_noisy = add_noise_polar(X,sigma_abs,sigma_arg)
% X_noisy = add_noise_polar(X,sigma_abs,sigma_arg)
% 
% INPUT
% - X           Clean values.
% - std_abs/arg Standard deviation of normally distributed noise.
% 
% OUTPUT
% - X_noise     Noisy values.

[n_rows,n_cols] = size(X);

X_abs = abs(X);
X_arg = angle(X);

N_abs = sigma_abs * randn(n_rows,n_cols) .* abs(X);
N_arg = sigma_arg * randn(n_rows,n_cols);

X_noisy = (X_abs+N_abs) .* exp(1i*(X_arg+N_arg));

end